#include <ESP8266WiFi.h>  
#include <SocketIoClient.h>
#include <ArduinoJson.h>

StaticJsonBuffer<500> jsonBuffer;
SocketIoClient webSocket;

const char* ssid     = "";        
const char* password = ""; 

const char* socketHost = "iot.megaads.vn";
const int socketPort = 443;

void socketConnected(const char * payload, size_t length) {
  Serial.println("Connected Socket.IO!");
}

void socketOnMessage(const char * payload, size_t length) {
  Serial.printf("Message: %s\n", payload);
}

void setup() {
  Serial.begin(9600);     
  delay(10);
  
  Serial.printf("\nConnect to Wifi %s", ssid);
  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print("\nConnecting!");  
  }

  Serial.println("\nConnection Established!");  
  Serial.print("IP Address: \t");
  Serial.println(WiFi.localIP());

  Serial.println("\nConnect to Socket.IO Server!");  
  webSocket.on("connect", socketConnected);

  JsonObject& device = jsonBuffer.createObject();
  device["bssid"] = "9A-8C-3D-4E-5F";
  device["name"] = "ZIPPY ESP8266";
  device["status"] = "connect";
  device["serial_number"] = "7365934853034957";
  device["fw_version"] = "1.0";
  device["signal_strength"] = 100;
  device["error_code"] = 1;
  JsonArray& pins = device.createNestedArray("pins");
  
  JsonObject& pin1 = pins.createNestedObject();
  pin1["pin"] = 1;
  pin1["status"] = "on";
  pin1["startup"] = "off"; 

  JsonObject& pin2 = pins.createNestedObject();
  pin2["pin"] = 2;
  pin2["status"] = "off";
  pin2["startup"] = "off"; 

  device.prettyPrintTo(Serial);

  char jsonChar[1000];
  device.printTo(jsonChar);
  Serial.printf("Device: %s\n", jsonChar);
  
  webSocket.emit("registerDevice", jsonChar);
  webSocket.on("message", socketOnMessage);
  
  webSocket.beginSSL(socketHost, socketPort);
}

void loop() {
   webSocket.loop();
}
